//#pragma LINK_INFO DERIVATIVE "mc9s12p128"

/******************************************************************************
													            Copyright (c) Freescale 2009
File Name    : $RCSfile: main.c,v $

Current Revision :	$Revision: 1.0 $

PURPOSE: main program entry.                       
                                                                          
                                                                       
DESCRIPTION:  function main() providing initial program entry.
                                                         
                                                                          
UPDATE HISTORY                                                            
REV  AUTHOR    DATE        DESCRIPTION OF CHANGE                          
---  ------    --------    ---------------------                          
1.0  r28318    17/09/09    - initial coding

     *******************************************************************
     * File created by: Freescale East Kilbride MSG Applications Group *
     *******************************************************************

                                                                          
******************************************************************************/
/*===========================================================================*/
/* Freescale reserves the right to make changes without further notice to any*/
/* product herein to improve reliability, function, or design. Freescale does*/
/* not assume any  liability arising  out  of the  application or use of any */
/* product,  circuit, or software described herein;  neither  does it convey */
/* any license under its patent rights  nor the  rights of others.  Freescale*/
/* products are not designed, intended,  or authorized for use as components */
/* in  systems  intended  for  surgical  implant  into  the  body, or  other */
/* applications intended to support life, or  for any  other application  in */
/* which the failure of the Freescale product  could create a situation where*/
/* personal injury or death may occur. Should Buyer purchase or use Freescale*/
/* products for any such intended  or unauthorized  application, Buyer shall */
/* indemnify and  hold  Freescale  and its officers, employees, subsidiaries,*/
/* affiliates,  and distributors harmless against all claims costs, damages, */
/* and expenses, and reasonable  attorney  fees arising  out of, directly or */
/* indirectly,  any claim of personal injury  or death  associated with such */
/* unintended or unauthorized use, even if such claim alleges that  Freescale*/
/* was negligent regarding the  design  or manufacture of the part. Freescale*/
/* and the Freescale logo* are registered trademarks of Freescale Ltd.       */
/*****************************************************************************/

/************************* Include Files *************************************/
/*general includes */
#include <hidef.h>  /* also includes boolean definitions in stdtypes.h     */
#include <MC9S12HY64.h>     /* derivative information */
#include "target.h" 
#include "S12HY_peripherals.h" /* includes peripherals definitions and FSL data types */


/************************* typedefs ******************************************/

/************************* #defines ******************************************/

/************************* Constants *****************************************/
#pragma CONST_SEG DEFAULT

/************************* Global Variables **********************************/
#pragma DATA_SEG DEFAULT

/************************* function prototypes *******************************/
#pragma CODE_SEG DEFAULT
/************************* Functions *****************************************/
#pragma CODE_SEG DEFAULT

/******************************************************************************
Function Name  : main
Engineer       : r28318	
Date           : 09/06/09
Parameters     : NONE
Returns        : NONE
Notes          : main routine called by Startup.c. 
******************************************************************************/


void main(void) {
   unsigned int x;						 /*outer loop counter */
   char y;									   /*inner loop counter */

   PTR = 0x01;  /* Initialise PORT R 0 High; turn off LED */
   DDRR = 0x01;   /* PORTR 0 = output */

   PER1AD = 0xF4; /* Enable pullups on Switches 1-4, and Transceiver Force Off */
   ATDDIENL = 0xF0;
   
   /* Wait for pull ups to come into effect */
  	for (x=0; x<1000; x++)
  	{	
  		for (y=0; y<100; y++)
  		{} 
	  }


    /* Select clock mode via Reset & switches   */
    /*                                          */
    /*     Default = PEI Mode  8.0MHz Bus Clock */
    /* Reset + SW1 = PEI Mode 12.5MHz Bus Clock */
    /* Reset + SW2 = PEE Mode 32.0MHz Bus Clock */
    /* Reset + SW3 = PBE Mode  2.0MHz Bus Clock */
    
      switch (PT1AD&0xF0)
      {
      
      case 0xB0:

         /* initialise the system clock PBE - 8MHz Crystal, 4MHz Bus CLK (32MHz VCO, 8MHz PLL)  */

         CPMUPROT = 0x26; /* Clear PROT bit, disable protection of clock configuration registers */

         CPMUSYNR = 0x01;  /* SYNDIV = 1, VCO frequency 32 - 48 MHz */       

         CPMUREFDIV = 0x80;  /* REFDIV = 10, REFCLK frequency 6-12MHz */       

         CPMUPOSTDIV = 0x01;  /* POSTDIV = 1 */

      	 CPMUCLKS = 0x80;  /* PLLSEL = 1*/

         while (CPMUCLKS != 0x80);  /* Verify CPMUCLKS configuration */

      	 CPMUOSC = 0xC2;  /* Enable Oscillator, OSCFILT = 2 */
       
         while(!CPMUFLG_UPOSC);	/* wait for OSC to stabilise */
         
      	 CPMUCLKS = 0x00;  /* PLLSEL = 0 */

         while (CPMUCLKS != 0x00);  /* Verify CPMUCLKS configuration */

         CPMUPROT = 0x00; /* Set PROT bit, enable protection of clock configuration registers */
        		   
         /* Configure the SCI to run at 9600 baud and Tx Clock Mode and Clock speeds */

         SCI_Config(0x1A);
         DisplayString("DEMOS12PFAME Board Running PBE Mode");
         LF;
         DisplayString("32MHz VCO Clock, 16MHz PLL Clock, 4MHz Bus Clock, from 8MHz Crystal");
         LF;
         LF;
    
      break;
      
      case 0xD0:
      
               /* initialise the system clock PEE - 64MHz VCO, 32MHz Bus CLK, from 8MHz Crystal */

         CPMUPROT = 0x26; /* Clear PROT bit, disable protection of clock configuration registers */

         CPMUSYNR = 0x43;  /* SYNDIV = 3, VCO frequency 48 - 64 MHz */

         CPMUREFDIV = 0x80;  /* REFDIV = 10 REFCLK frequency 6-12MHz */     

         CPMUPOSTDIV = 0x00;  /* POSTDIV = 0 */

      	 CPMUCLKS = 0x80;  /* PLLSEL = 1 */

         while (CPMUCLKS != 0x80);  /* Verify CPMUCLKS configuration */

      	 CPMUOSC = 0xC4;  /* Enable Oscillator, OSCFILT = 4 */
       
         CPMUPROT = 0x00; /* Set PROT bit, enable protection of clock configuration registers */

         while(!CPMUFLG_UPOSC);	/* wait for OSC to stabilise */

         while(!CPMUFLG_LOCK);	/* wait for PLL to lock */

         /* Configure the SCI to run at 9600 baud and Tx Clock Mode and Clock speeds */

         SCI_Config(0xD0);
         DisplayString("DEMOS12PFAME Board Running PEE Mode");
         LF;
         DisplayString("64 MHz VCO Clock, 64MHz PLL Clock, 32MHz Bus Clock from 8MHz Crystal");
         LF;
         LF;

      break;
      
      case 0xE0:
                    
               /* initialise the system clock PEI - 50MHz VCO, 12.5MHz Bus CLK, from 1MHz Internal Clock */

         CPMUPROT = 0x26; /* Clear PROT bit, disable protection of clock configuration registers */

         CPMUSYNR = 0x58;  /* SYNDIV = 24, VCO frequency 48 - 64 MHz */

         CPMUPOSTDIV = 0x01;  /* POSTDIV = 1 */

      	 CPMUCLKS = 0x80;  /* PLLSEL = 1 */

         while (CPMUCLKS != 0x80);  /* Verify CPMUCLKS configuration */
         
         CPMUPROT = 0x00;  /* Set PROT bit, enable protection of clock configuration registers */

         while(!CPMUFLG_LOCK);	/* wait for PLL to lock */
        		   
         /* Configure the SCI to run at 9600 baud and Tx Clock Mode and Clock speeds */

         SCI_Config(0x51);
         DisplayString("DEMOS12PFAME Board Running User Configured PEI Mode");
         LF;
         DisplayString("50MHz VCO Clock, 25MHz PLL Clock, 12.5MHz Bus Clock from 1MHz Internal Clock");
         LF;
         LF;
      
      break;
      
      default: 
        {
          
         /* Configure the SCI to run at 9600 baud and Tx Clock Mode and Clock speeds */

         SCI_Config(0x34);
         DisplayString("DEMO9S12HY64 Board Running DEFAULT PEI Mode");
         LF;
         DisplayString("64MHz VCO Clock, 16MHz PLL Clock, 8MHz Bus Clock from 1MHz Internal Clock");
         LF;
         LF;
        }
      }
      
   ECLKCTL = 0x00;  /* Enable ECLK = Bus Clock */                   

   while(1)
   {
     PTR ^=0x01;
     /* Delay to see LED toggle */
     for (x=0; x<2000; x++)
  	 {	
   		 for (y=0; y<100; y++)
  		 {} 
	   }
   }
      
  		
}
